#pragma once 
#include "Shader.h"
#include <GL/gl.h>
#include <string>
#include <unordered_map>

namespace graphics
{
	/*!
		Shader program
	*/
class ShaderProgram
{
public:
    ShaderProgram();
	/*!
		Links the vertex shader and the fragment shader to a program
	*/
    ShaderProgram(Shader * vertexShader, Shader * fragmentShader);
	ShaderProgram(const ShaderProgram & program) = delete;
	ShaderProgram & operator = (const ShaderProgram & program) = delete;
	~ShaderProgram();
	/*!
		binds the programs to be used
	*/
    void useProgram();
	const GLuint getProgram() {
		return m_program;
	}
	/*!
		returns uniform location in the program
	*/
	GLint getLocation(const char * uniformName);
	/*!
	returns uniform location in the program
	*/
	GLint getLocation(const std::string & uniformName);
private:
    GLuint m_program;
    void link();
    void validate();
	typedef std::unordered_map<std::string, GLint> LocationContainer;
	LocationContainer m_locations;
};

};

